// Edge N Splitter.js
//
// tg@tres-graficos.jp
// Hiroto Tsubaki
//
// Tool script for ~/Library/Application Support/Cheetah3D/scripts/Tool folder to install.
//
// update 2012/02/28: added undo code.

function buildUI( tool ) {
    
    tool.addParameterInt("split count", 2, 2, 100, false, false);
    tool.addParameterButton("split", "split", "splitEdge");
    
}

var edgeList = [];

function splitEdge( tool ) {
    var obj = tool.document().selectedObject();
    
    if (!obj || obj.type() != POLYGONOBJ) return;
    if (tool.document().editMode() != EDGE_MODE && tool.document().editMode() != POINT_MODE) return;
    
    var sc = tool.getParameter("split count");
    
    var core = obj.core();
    
    edgeList.length = 0;
    
    if (tool.parameterWithName) obj.recordGeometryForUndo(); // not yet.
    
    var polygonCount = core.polygonCount();
    var polygonSize = 0;
    for(var i = 0;i < polygonCount;i++) {
        var polygonSize = core.polygonSize( i );
        for (var j = 0;j < polygonSize;j++) {
            if (core.edgeSelection(i, j, SELECT)) {
                var v1 = core.vertexIndex( i, j );
                var v2 = core.vertexIndex( i, ((j == polygonSize-1)? 0 : j + 1) );
                var ei = edgeList.pushEdge( new Edge(i, j, v1, v2) );
                if (ei > -1) {
                    edgeList[ ei ].p2 = i;
                    edgeList[ ei ].c2 = j;
                }
            }
        }
    }
    // print('===');
    // print( 'edges ('+edgeList.length+'): '+edgeList );
    
    var delList = [];
    var len = edgeList.length;
    
    var pIndices = new PolyIndices();
    
    for (var i = 0;i < len;i++) {
        var edge = edgeList[i];
        
        if (! pIndices[edge.p1]) {
            pIndices[edge.p1] = edge.p1;
        }
        if (! pIndices[edge.p2]) {
            pIndices[edge.p2] = edge.p2;
        }
    }
    
    for (var i = 0;i < len;i++) {
        var edge = edgeList[i];
        
        var v1 = core.vertex( edge.v1 );
        var v2 = core.vertex( edge.v2 );
        
        var indices = [];
        
        for (var j = 0;j < sc-1;j++) {
            var sv1 = v1.multiply( (1+j)/sc );
            var sv2 = v2.multiply( (sc - 1 - j)/sc );
            var vec = sv1.add( sv2 );
            
            indices.push( core.addVertex( false, vec ) );
        }
        
        // print( i+' - indices:'+indices );
        // print('-');
        
        var pList = [ edge.p1, edge.p2 ];
        for (var k = 0;k < 2;k++) {
            var p = pIndices[ pList[k] ];
            // print( k + ': ' + pList[k] + ' -> '+ p );
            if (p != undefined) {
                
                var newIndices = [];
                var newUvs = [];
                var newSelection = [];
                var newCrease = [];
                
                var uv1, uv2;
                
                var lenIndices = indices.length;
                var concated = false;
                
                var polygonSize = core.polygonSize( p );
                for (var j = 0;j < polygonSize;j++) {
                    var nv = core.vertexIndex( p, j );
                    if (!concated) {
                        if ( nv == edge.v1 ) {
                            if ( core.vertexIndex( p, j+1) == edge.v2 ) {
                                newIndices.push( nv );
                                newIndices = newIndices.concat( indices.slice(0).reverse() );
                                
                                uv1 = core.uvCoord( p, j );
                                uv2 = core.uvCoord( p, j+1 );
                                newUvs.push( uv1 );
                                for( var l = 0;l < lenIndices;l++) {
                                    newUvs.push( uv1.multiply( (lenIndices - l)/(lenIndices+1) ).add( uv2.multiply( (l+1)/(lenIndices+1)) ) );
                                    // print( (lenIndices - l) + '/' + (lenIndices+1) + ' + ' + (l+1) + '/' + (lenIndices+1) );
                                }
                                
                                // print('A:'+j+','+(j+1)+'/'+(polygonSize-1));
                                newSelection.push( core.edgeSelection( p, j, SELECT) );
                                newCrease.push( core.edgeSelection( p, j, CREASE ) );
                                for( var l = 0;l < lenIndices;l++) {
                                    newSelection.push( true );
                                    newCrease.push( core.edgeSelection( p, j, CREASE ) );
                                }
                            } else {
                                newIndices = newIndices.concat( indices );
                                newIndices.push( nv );
                                
                                uv1 = core.uvCoord( p, j );
                                uv2 = core.uvCoord( p, polygonSize - 1 );
                                for( var l = 0;l < lenIndices;l++) {
                                    newUvs.push( uv1.multiply( (1+l)/(lenIndices+1) ).add( uv2.multiply( (lenIndices - l)/(lenIndices+1)) ) );
                                }
                                newUvs.push( uv1 );
                                
                                // print('B:'+j+','+(j+1)+'/'+(polygonSize-1));
                                for( var l = 0;l < lenIndices;l++) {
                                    newSelection.push( true );
                                    newCrease.push( core.edgeSelection( p, j, CREASE ) );
                                }
                                newSelection.push( core.edgeSelection( p, j, SELECT) );
                                newCrease.push( core.edgeSelection( p, j, CREASE ) );
                            }
                            concated = true;
                        } else if ( nv == edge.v2 ) {
                            if ( core.vertexIndex( p, j+1) == edge.v1 ) {
                                newIndices.push( nv );
                                newIndices = newIndices.concat( indices );
                                
                                uv1 = core.uvCoord( p, j );
                                uv2 = core.uvCoord( p, j+1 );
                                newUvs.push( uv1 );
                                for( var l = 0;l < lenIndices;l++) {
                                    newUvs.push( uv1.multiply( (lenIndices - l)/(lenIndices+1) ).add( uv2.multiply( (l+1)/(lenIndices+1)) ) );
                                    // print( (lenIndices - l) + '/' + (lenIndices+1) + ' + ' + (l+1) + '/' + (lenIndices+1) );
                                }
                                
                                // print('C:'+j+','+(j+1)+'/'+(polygonSize-1));
                                newSelection.push( core.edgeSelection( p, j, SELECT) );
                                newCrease.push( core.edgeSelection( p, j, CREASE ) );
                                for( var l = 0;l < lenIndices;l++) {
                                    newSelection.push( true );
                                    newCrease.push( core.edgeSelection( p, j, CREASE ) );
                                }
                            } else {
                                newIndices = newIndices.concat( indices.slice(0).reverse() );
                                newIndices.push( nv );
                                
                                uv1 = core.uvCoord( p, j );
                                uv2 = core.uvCoord( p, polygonSize - 1 );
                                for( var l = 0;l < lenIndices;l++) {
                                    newUvs.push( uv1.multiply( (1+l)/(lenIndices+1) ).add( uv2.multiply( (lenIndices - l)/(lenIndices+1)) ) );
                                }
                                newUvs.push( uv1 );
                                
                                // print('D:'+j+','+(j+1)+'/'+(polygonSize-1));
                                for( var l = 0;l < lenIndices;l++) {
                                    newSelection.push( true );
                                    newCrease.push( core.edgeSelection( p, j, CREASE ) );
                                }
                                newSelection.push( core.edgeSelection( p, j, SELECT) );
                                newCrease.push( core.edgeSelection( p, j, CREASE ) );
                            }
                            concated = true;
                        } else {
                            newIndices.push( nv );
                            newUvs.push( core.uvCoord( p, j ) );
                            
                            newSelection.push( core.edgeSelection( p, j, SELECT) );
                            newCrease.push( core.edgeSelection( p, j, CREASE ) );
                        }
                    } else {
                        newIndices.push( nv );
                        newUvs.push( core.uvCoord( p, j ) );
                        
                        newSelection.push( core.edgeSelection( p, j, SELECT ) );
                        newCrease.push( core.edgeSelection( p, j, CREASE ) );
                        
                    }
                }
                // print( 'newIndex for p'+k+': '+newIndices );
                var newIndex = core.addIndexPolygon( newIndices.length, newIndices );
                for(var l = 0;l < newUvs.length;l++) {
                    core.setUVCoord( newIndex, l, newUvs[l] );
                }
                delList.push( p ); //core.deletePolygon( p );
                
                // set selection for added polygon
                // print( 'selection:'+newSelection );
                var lenSelection = newSelection.length;
                for (var l = 0;l < lenSelection;l++) {
                    if (newSelection[l]) core.setEdgeSelection( newIndex, l, SELECT, true );
                    if (newCrease[l]) core.setEdgeSelection( newIndex, l, CREASE, true );
                }
                
                
                pIndices[pList[k]] = newIndex;
                // print( pIndices );
                // print( '-' );
            }
        }
    }
    
    delList = delList.sort( function(a, b) { return (b-a); } );
    // print( 'del:'+delList );
    len = delList.length;
    for (var i = 0;i < len;i++) {
        core.deletePolygon( delList[i] );
    }
    
    obj.update();
}

function Edge(_p1, _c1, _v1, _v2) {
    this.p1 = _p1;
    this.c1 = _c1;
    
    this.p2 = undefined;
    this.c2 = undefined;
    
    this.v1 = _v1;
    this.v2 = _v2;
}

function PolyIndices() {};

PolyIndices.prototype.toString = function() {
    var str = '';
    for (var prop in this) {
        if (prop.match(/^[0-9]+$/)) str += prop + ': ' + this[prop] + ', ';
    }
    return str;
}

Array.prototype.pushEdge = function(_edge) {
    var result = -1;
    var len = this.length;
    for(var i = 0;i < len;i++) {
        if (this[i].isEqualTo(_edge)) {
            result = i;
        }
    }
    if (result == -1) this.push( _edge);
    return result;
}

Edge.prototype.isEqualTo = function(_edge) {
    return ((this.v1 == _edge.v1 && this.v2 == _edge.v2) || (this.v2 == _edge.v1 && this.v1 == _edge.v2));
}

Edge.prototype.toString = function() {
    return 'p1: '+this.p1+', c1: '+this.c1+', p2: '+this.p2+', c2: '+this.c2+', v('+this.v1+','+this.v2+')';
}
